* Title: 	table4.do
* Version: 	23 May 2018
* Purpose: 	Produce regressions of China trade shocks at commuting zone level
 
*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table4, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Construct commuting-zone level variables 
*******************************************************************************

foreach sample in 1990 2000 2007 {

	if "`sample'" == "1990" 						local pumavar puma1990
	if "`sample'" == "2000" | "`sample'" == "2007" 	local pumavar puma2000

	use year statefip puma PrimeMaleD UnempB LTJoblessB perwt ///
		using dta/census_clean, clear

	* Pool 2006-2008 ACS
	replace year = 2007 if year>=2006 & year<=2008

	* Keep only prime-age men
	keep if PrimeMaleD == 1

	* Keep only sample year
	keep if year == `sample'

	*Recode PUMAs and merge on Dorn commuting zone crosswalk
	gen `pumavar' = statefip * 10000 + puma
	
	* For 2006-2008 ACS, correct for impact of Katrina on PUMAs
	if "`sample'" == "2007" replace `pumavar' = 221801 if (`pumavar' == 297777) 
	
	joinby `pumavar' using dta/cw_`pumavar'_czone
	gen perwt2 = perwt * afactor

	collapse (sum)   Total = PrimeMaleD  ///
					 Jobless = UnempB /// 
					 LTJobless = LTJoblessB ///
					 [pw=perwt2], by(czone)

	gen double Jobless_Rate`sample' 	= Jobless / Total
	gen double LTJobless_Rate`sample' 	= LTJobless / Total
	
	keep czone Jobless_Rate LTJobless_Rate
	
	tempfile `sample'
	save ``sample''

}

use `1990', clear
merge 1:1 czone using `2000', nogen
merge 1:1 czone using `2007', nogen

* Generate indicator for high jobless rate in 1990
summarize Jobless_Rate1990, detail
gen High_Jobless = (Jobless_Rate1990 >= `r(p90)')

* Compute percentage-point changes in jobless rates
foreach rate in Jobless LTJobless {
	gen Delta_`rate'1990 = (100) 		* (`rate'_Rate2000 - `rate'_Rate1990)
	gen Delta_`rate'2000 = (100 * 10/7) * (`rate'_Rate2007 - `rate'_Rate2000)
}


*******************************************************************************
* (2) Merge with Autor/Dorn/Hanson China shock data
*******************************************************************************

keep czone Delta_* High_Jobless
reshape long Delta_Jobless Delta_LTJobless, i(czone) j(yr)

merge 1:1 czone yr using dta/workfile_china, assert(master matched) keep(matched) nogen

* Generate interaction terms for high jobless rate
gen d_tradeusch_pw_High 	= High_Jobless * d_tradeusch_pw
gen d_tradeotch_pw_lag_High = High_Jobless * d_tradeotch_pw_lag

* Save dataset
save output/tables/dta/table4.dta, replace


*******************************************************************************
* (3) Regressions
*******************************************************************************

* Column 1: Jobless rate, no interactions
ivregress 2sls Delta_Jobless 	(d_tradeusch_pw = d_tradeotch_pw_lag) ///
								l_shind_manuf_cbp l_sh_popedu_c l_sh_popfborn l_sh_empl_f l_sh_routine33 l_task_outsource reg* t2 ///
								[aw=timepwt48], cluster(statefip)

* Column 2: Jobless rate, interactions with high non-employment
ivregress 2sls Delta_Jobless 	(d_tradeusch_pw d_tradeusch_pw_High = d_tradeotch_pw_lag d_tradeotch_pw_lag_High) ///
								l_shind_manuf_cbp l_sh_popedu_c l_sh_popfborn l_sh_empl_f l_sh_routine33 l_task_outsource reg* t2 ///
								[aw=timepwt48], cluster(statefip)

* Column 3: Long-term jobless rate, no interactions
ivregress 2sls Delta_LTJobless 	(d_tradeusch_pw=d_tradeotch_pw_lag) ///
								l_shind_manuf_cbp l_sh_popedu_c l_sh_popfborn l_sh_empl_f l_sh_routine33 l_task_outsource reg* t2 ///
								[aw=timepwt48], cluster(statefip)

* Column 4: Long-term jobless rate, interactions with high non-employment
ivregress 2sls Delta_LTJobless 	(d_tradeusch_pw d_tradeusch_pw_High = d_tradeotch_pw_lag d_tradeotch_pw_lag_High) ///
								l_shind_manuf_cbp l_sh_popedu_c l_sh_popfborn l_sh_empl_f l_sh_routine33 l_task_outsource reg* t2 ///
								[aw=timepwt48], cluster(statefip)


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
